/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.editor.common.IPartitionScannerSwitchStrategy;
import com.aptana.editor.common.TextUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;

public class SequenceCharacterScanner
implements ICharacterScanner {
    private ICharacterScanner characterScanner;
    private IPartitionScannerSwitchStrategy switchStrategy;
    private IPartitionScannerSwitchStrategy.ISequenceBypassHandler sequenceBypassHandler;
    private char[][] switchSequences;
    private boolean found = false;
    private boolean eof = false;
    private boolean ignored;
    private boolean ignoreCase;

    public SequenceCharacterScanner(ICharacterScanner characterScanner, IPartitionScannerSwitchStrategy switchStrategy) {
        this(characterScanner, switchStrategy, false);
    }

    public SequenceCharacterScanner(ICharacterScanner characterScanner, IPartitionScannerSwitchStrategy switchStrategy, boolean ignoreCase) {
        this.characterScanner = characterScanner;
        this.switchStrategy = switchStrategy;
        this.ignoreCase = ignoreCase;
        this.sequenceBypassHandler = switchStrategy.getSequenceBypassHandler();
    }

    public int getColumn() {
        return this.characterScanner.getColumn();
    }

    public char[][] getLegalLineDelimiters() {
        return this.characterScanner.getLegalLineDelimiters();
    }

    public int read() {
        this.eof = false;
        int c = this.characterScanner.read();
        if (c != -1 && !this.ignored) {
            if (this.switchSequences == null) {
                this.switchSequences = TextUtils.replace(this.switchStrategy.getSwitchSequences(), '\n', TextUtils.rsort(this.characterScanner.getLegalLineDelimiters()));
            }
            char[][] cArray = this.switchSequences;
            int n = this.switchSequences.length;
            int n2 = 0;
            while (n2 < n) {
                char[] sequence = cArray[n2];
                if (c == sequence[0] && TextUtils.sequenceDetected(this.characterScanner, sequence, this.ignoreCase)) {
                    this.characterScanner.unread();
                    if (this.sequenceBypassHandler == null || !this.sequenceBypassHandler.bypassSequence(this.characterScanner, sequence)) {
                        this.found = true;
                        this.eof = true;
                        return -1;
                    }
                    Assert.isTrue((c == this.characterScanner.read() ? 1 : 0) != 0);
                }
                ++n2;
            }
        }
        return c;
    }

    public void unread() {
        if (this.eof) {
            this.eof = false;
            return;
        }
        this.found = false;
        this.characterScanner.unread();
    }

    public boolean foundSequence() {
        return this.foundSequence(true);
    }

    public boolean foundSequence(boolean reset) {
        try {
            boolean bl = this.found;
            return bl;
        }
        finally {
            if (reset) {
                this.found = false;
            }
        }
    }

    public void setSequenceIgnored(boolean ignored) {
        this.ignored = ignored;
    }
}

